//
//	base.js
//
//		1. This source code is MIT licence.
//		2. Copyright(C) All rights 2012 blueskis
//		3. If you find bugs that I have to fix , Please send mail blueskis382 @ gmail.com
//
//		1. このソースコードはMIT licenceとして配布します。
//		3. もしバグを見つけたら、 blueskis382 @ gmail.com にメールを送っていただけたらうれしいです。
//

//IE死ね!
//IE9以下全てのバージョン死んでしまえ!
//ついでにFirefox3以下、Opera10以下、Safari4以下、iPhone版Safari、Android版Safari、
//およびIntent使って標準ブラウザ採用しているDolphine Browser全て死んでしまえ!

var Invariant = new Array() ;
Invariant["APP_NAME"] = "BIEditor" ;

var util = {
	//サポートされているかのチェック
	SupportedChecker : function(){
		var str = "" ;
		if(!window.File) str += "・ファイルを開く/保存する機能、画像を表示する機能\n" ;
		if(!str == "") alert("このWebブラウザでは以下の機能が利用できません。\n" + str) ;
	} ,
	//拡張子からCodeMirror用のMIME Typeに設定
	TransmissionMIMETypeForCodeMirror : function(elem){
		var querys = [
			[".php" , "application/x-httpd-php"] ,
			[".pl" , "text/x-perl"] ,
			[".html" , "text/html"] ,
			[".xml" , "text/xml"] ,
			[".css" , "text/css"] ,
			[".xml" , "application/xml"] ,
			[".xul" , "application/xml"] ,
			[".rss" , "application/xml"] ,
			[".js" , "text/javascript"] ,
			[".jse" , "text/javascript"] ,
			[".vbs" , "text/vbscript"] ,
			[".vb" , "text/vbscript"] ,
			[".c" , "text/x-csrc"] ,
			[".cpp" , "text/x-c++src"] ,
			[".cshape" , "text/x-csharp"] ,
			[".java" ,  "text/x-java"] ,
			[".coffee" , "text/x-coffeescript"] ,
			[".sql" , "text/x-mysql"] ,
			[".py" , "text/x-python"] ,
			[".rb" , "text/x-ruby"] ,
			[".less" , "text/x-less"] ,
			[".diff" , "text/x-diff"] ,
			[".json" , "application/json"] ,
			[".ini" , "text/x-ini"] ,
			[".sh" , "text/x-sh"] ,
			[".bash" , "text/x-sh"] 
		] ;
		for(var i=0;i<querys.length;i++){
			if(elem.val().indexOf(querys[i][0]) != -1)
				return querys[i][1] ;
		}
		return "text/x-rst" ;
	}
}
var editor = null , hlLine = null , _storage = null ;
window.xstorage = function(uu , storage){
	_storage = storage ;
	if(storage.get("TextEditor.ThemeSelector")){
		$("#theme-selector").val(storage.get("TextEditor.ThemeSelector")) ;
		$("#keyMap").val(storage.get("TextEditor.keyMap")) ;
		$("#background_image_src").val(storage.get("TextEditor.BackGroundImageSource")) ;
		$("#background_opacity").val(storage.get("TextEditor.BackGroundImageOpacity")) ;
		$("#TabSize").val(storage.get("TextEditor.TabSize")) ;
		
		if(storage.get("TextEditor.LineNumberShow") == "true")
			$("#lineNumbers")[0].checked = true ;
		else
			$("#lineNumbers")[0].checked = false ;
		
		$("#background_image").attr("src" , storage.get("TextEditor.BackGroundImageSource")) 
							.css("opacity" , storage.get("TextEditor.BackGroundImageOpacity")) ;
	}
							
	var str = "" ;
	var cnt = 0 ;
	
	for(var s in storage.getAll()){
		if(s.indexOf("TextEditor") != -1){
			str +=  "<tr><td>" + s + "</td><td><input type=\"text\" value=\"" + storage.get(s) + "\"></td></tr>" ;
		}
		$("#storage_result").html(str) ;
		cnt++ ;
	}
	editor = CodeMirror.fromTextArea(document.getElementById("editor"), {
		lineNumbers: (storage.get("TextEditor.LineNumberShow") ? storage.get("TextEditor.LineNumberShow") : true) ,
		tabSize: (storage.get("TextEditor.TabSize") ? storage.get("TextEditor.TabSize") : 4) ,
		indentUnit: 4,
		indentWithTabs: true ,
		theme : (storage.get("TextEditor.ThemeSelector") ? storage.get("TextEditor.ThemeSelector") : "eclipse") ,
		onCursorActivity: function() {
			editor.setLineClass(hlLine, null, null);
			hlLine = editor.setLineClass(editor.getCursor().line, null, "activeline");
		} ,
		onGutterClick: function(cm, n) {
			var info = cm.lineInfo(n);
			if (info.markerText)
				cm.clearMarker(n);
			else
				cm.setMarker(n, "<span style=\"color: #900\">●</span> %N%");
		} ,
		mode: "text/plain" ,
		profile : "html" ,
		keyMap : (storage.get("TextEditor.KeyMap") ? storage.get("TextEditor.KeyMap") : "default")
	});
	editor.setValue("") ;
	hlLine = editor.setLineClass(0, "activeline");
	//
	//dialog setting by jQuery UI
	//

	$('[data-action="Open"]').click(function(){
		$("#Open").dialog("open") ;
	}) ;
	$('[data-action="About"]').click(function(){
		$("#About").dialog("open") ;
	}) ;
	$('[data-action="Save"]').click(function(){
		var blobBuilder;
		if ("MozBlobBuilder" in window) {
			blobBuilder = new MozBlobBuilder();
		} else if ("WebKitBlobBuilder" in window) {
			blobBuilder = new WebKitBlobBuilder();
		}

		blobBuilder.append(editor.getValue());
	
		if (window.URL) 
			window.open( window.URL.createObjectURL(blobBuilder.getBlob()) ) ;
		else if (window.webkitURL)
			window.open(window.webkitURL.createObjectURL(blobBuilder.getBlob()) );

	}) ;
	$('[data-action="SaveAs"]').click(function(){
	}) ;
	$('[data-action="Print"]').click(function(){
		window.print() ;
	}) ;
	$('[data-action="Exit"]').click(function(){
		window.close() ;
	}) ;
	$('[data-action="Undo"]').click(editor.undo)
	$('[data-action="Redo"]').click(editor.redo)
	$('[data-action="Copy"]').click(function(){
		document.execCommand("copy") ;
	}) ;
	$('[data-action="Paste"]').click(function(){
		document.execCommand("paste") ;
	}) ;
	$('[data-action="Delete"]').click(function(){
		document.execCommand("delete") ;
	}) ;
	$('[data-action="SelectAll"]').click(function(){
		document.execCommand("selectAll") ;
	}) ;
	$('[data-action="SettingEnvironment"]').click(function(){
		$("#SettingEnvironment").dialog("open") ;
	}) ;
	$('[data-action="Search"]').click(function(){
		$("#searchbox").dialog("open") ;
	}) ;
	$('[data-action="Replace"]').click(function(){
		$("#replacebox").dialog("open") ;
	}) ;
	$('[data-action="reload_storage_data"]').click(function(){
		var str = "" ;
		for(var s in window.localStorage){
			if(s.indexOf("TextEditor") != -1){
				str +=  "<tr><td>" + s + "</td><td><input type=\"text\" value=\"" + (window.localStorage.getItem(s)) + "\"></td></tr>" ;
			}
			$("#storage_result").html(str) ;
		}
	}) ;
	$('[data-action="NewDocument"]').click(function(){
		document.title = Invariant["APP_NAME"] ;
		editor.setValue("") ;
	}) ;
	$('[data-action="New_Tab"]').click(function(){
		window.open(location.href) ;
	}) ;
	//setting dialog box
	$("#Open").dialog({
		modal : true ,
		draggable : true ,
		title : "ファイルを開く" ,
		height : 240 ,
		width : 320 ,
		autoOpen : false ,
		buttons : {
			"OK" : function(event){
				var reader = new FileReader() ;
				reader.onload = function(event){
					editor.setValue(event.target.result) ;
				} ;
				reader.readAsText($("#Open-file-chooser")[0].files[0] , "utf-8") ;
				var mime = util.TransmissionMIMETypeForCodeMirror($("#Open-file-chooser")) ;
				editor.setOption("mode" , mime) ;
				
				document.title = Invariant["APP_NAME"] + " -" + $("#Open-file-chooser").val() ;
				$("#Open").dialog("close") ;
			} ,
			"キャンセル" : function(event){
				$("#Open").dialog("close") ;
			}
		}
	}) ;
	$("#searchbox").dialog({
		modal : false ,
		draggable : true ,
		title : "検索" ,
		height : 200 ,
		width : 300 ,
		autoOpen : false ,
		buttons : {
			"検索" : function(){
				console.log(CodeMirror.commands.find) ;
				CodeMirror.commands.find($("#search_query").val() , editor) ;
			} ,
			"閉じる" : function(){
				$("#searchbox").dialog("close") ;
			}
		}
	}) ;
	$("#replacebox").dialog({
		modal : false ,
		draggable : true ,
		width : 530 ,
		height : 190 ,
		title : "置換" ,
		autoOpen : false ,
		buttons : {
			"検索" : function(){
				CodeMirror.commands.find($("#search_query_for_replace").val() , editor) ;
			} ,
			"すべて置換" : function(){
				CodeMirror.commands.replace(editor , true) ;
			}
		}
	}) ;
	$("#SettingEnvironment").dialog({
		modal : true ,
		draggable : true ,
		title : "環境設定" ,
		height : 400 ,
		width : 400 ,
		autoOpen : false ,
		buttons : {
			"OK" : function(){
				//テーマの設定
				editor.setOption("theme" , $("#theme-selector option:selected").val()) ;
				storage.set("TextEditor.ThemeSelector" , $("#theme-selector option:selected").val()) ;
				
				//キーマップの設定
				editor.setOption("keyMap" , $("#keyMap option:selected").val()) ;
				storage.set("TextEditor.keyMap" , $("#keyMap option:selected").val()) ;
				
				//行番号の表示の有無
				editor.setOption("lineNumbers" , $("#lineNumbers").is(":checked")) ;
				storage.set("TextEditor.LineNumberShow" , $("#lineNumbers").is(":checked")) ;
				
				//背景画像の設定
				$("#background_image").attr("src" , $("#background_image_src").val()) ;
				storage.set("TextEditor.BackGroundImageSource" , $("#background_image_src").val()) ;
				
				//背景画像透過率の設定
				$("#background_image").css("opacity" , $("#background_opacity").val()) ;
				storage.set("TextEditor.BackGroundImageOpacity" , $("#background_opacity").val()) ;
				
				//タブサイズの設定
				editor.setOption("tabSize" , $("#TabSize").val()) ;
				storage.set("TextEditor.TabSize" , $("#TabSize").val()) ;
				
				$("#SettingEnvironment").dialog("close") ;
			} ,
			"キャンセル" : function(){
				$("#SettingEnvironment").dialog("close") ;
			}
		}
	}) ;
	$("#About").dialog({
		modal : false ,
		draggable : true ,
		title : Invariant["APP_NAME"] + "について" ,
		height : 400 ,
		width : 320 ,
		buttons : {
			"OK" : function(e){
				$("#About").dialog("close") ;
			}
		} ,
		autoOpen : false
	}) ;

	
	$("#setenv-tabs").tabs() ;
	
	//エディタサイズを補正
	if(window.ActiveXObject)
		$(".CodeMirror-scroll").css("height" , (document.documentElement.clientHeight - 20) + "px")
	else
		$(".CodeMirror-scroll").css("height" , (window.innerHeight - 20) + "px")
	$(window).resize(function(){
		if(window.ActiveXObject)
			$(".CodeMirror-scroll").css("height" , (document.documentElement.clientHeight - 20) + "px") ;
		else
			$(".CodeMirror-scroll").css("height" , (window.innerHeight - 20) + "px")
	}) ;
	editor.setValue("\n") ;
	
}
$(function(){
	
	if(window.ActiveXObject){
		$("html").addClass("ie")
	}
	//CodeMirror
	document.title = Invariant["APP_NAME"] + " -無題" ;

	$("ul.sub").hide();
	$("ul.menubar li").hover(
		function(){
			$(">ul:not(:animated)",this).show() ;
		},
		function(){
			$(">ul",this).hide();
		}
	)


}) ;